//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit2.h"
#include "Unit1.h"
#include "inifiles.hpp"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm2 *Form2;
TPrintDialog *PrntDlg;
TPrinterSetupDialog *PrintSetupDlg;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
  Application->OnIdle = &AppIdle;
}
//---------------------------------------------------------------------------
// finds offline for a short while !!!

void __fastcall TForm2::FindDlgFind(TObject *Sender)
{
/*//  UpdateActiveEditor();

  if ( (ActiveEditor->SelLength > 0) & (ActiveEditor->SelLength < 30))
  FindDlg->FindText = ActiveEditor->SelText;

  TFindDialog* Dlg = dynamic_cast<TFindDialog*>(Sender);
  TSearchTypes Options;  //TSearchType { stWholeWord, stMatchCase };
  if (Dlg->Options.Contains(frWholeWord)) Options << stWholeWord;
  if (Dlg->Options.Contains(frMatchCase)) Options << stMatchCase;

  // Deselect any selected text and advance the cursor position.
  // This prevents us from selecting the sametext over and over again.
  if (ActiveEditor->SelLength)
  {
    ActiveEditor->SelStart += ActiveEditor->SelLength;
    ActiveEditor->SelLength = 0;
  }

  // Find the text.
  int Pos = ActiveEditor->FindText(Dlg->FindText,ActiveEditor->SelStart, ActiveEditor->GetTextLen(), Options);

  // If the text is found then highlight it, scroll the window to the found text,
  // and set focus to the RichEdit control. If no text is found let the user know.
  if (Pos != -1) {
    ActiveEditor->SelStart = Pos;
    ActiveEditor->SelLength = Dlg->FindText.Length();
    ActiveEditor->Perform(EM_SCROLLCARET, 0, 0);
    ActiveEditor->SetFocus();
    Dlg->CloseDialog();
  }
  else
  {
    MessageBox(Application->Handle, "Search text not found.", "Find Text", MB_OK);
    Dlg->CloseDialog();
  }


  */
}
//---------------------------------------------------------------------------
void __fastcall TForm2::ReplaceDlgReplace(TObject *Sender)
{
/*
  // If the user clicked the Replace All button then we need to do a
  // find/replace operation until no more matches are found.
  if (ReplaceDlg->Options.Contains(frReplaceAll))
  {
    static int Count;
    TSearchTypes Options;
    if (ReplaceDlg->Options.Contains(frWholeWord)) Options << stWholeWord;
    if (ReplaceDlg->Options.Contains(frMatchCase)) Options << stMatchCase;

    // Find the first match.
    int Pos = ActiveEditor->FindText(ReplaceDlg->FindText, ActiveEditor->SelStart, ActiveEditor->GetTextLen(), Options);

    // Loop while we are still finding text.
    while (Pos != -1)
    {
      // Same code as in the OnFind event handler.
      ActiveEditor->SelStart = Pos;
      ActiveEditor->SelLength = ReplaceDlg->FindText.Length();

      // Replace the found text with the new text.
      ActiveEditor->SetSelTextBuf(ReplaceDlg->ReplaceText.c_str());

      // Increment the counter so we can tell the user
      ActiveEditor->Perform(EM_SCROLLCARET, 0, 0);

      // how many replacements we made.
      Count++;

      // Do another search.
      Pos = ActiveEditor->FindText(ReplaceDlg->FindText, ActiveEditor->SelStart, ActiveEditor->GetTextLen(), Options);
    }

    // Dismiss the Replace dialog.
    ReplaceDlg->CloseDialog();

    // Tell the user what we did.
    char buff[40];
    sprintf(buff, "Finished searching text.\r\n" "%d replacements made.", Count);
    MessageBox(Application->Handle, buff, "Replace Text", MB_OK);

    // Reset the counter.
    Count = 0;
  }
  // If not doing a Replace All then just replace the
  // found text with the new text.
  else
  {
    // No text selected? Then return.
    if (ActiveEditor->SelLength == 0) return;
    ActiveEditor->SetSelTextBuf(ReplaceDlg->ReplaceText.c_str());
    ActiveEditor->SelLength = 0;
  }
  // Set focus to the RichEdit.
  ActiveEditor->SetFocus();
  ReplaceDlg->CloseDialog();
*/

}


void __fastcall TForm2::OnGetMinMaxInfo(TWMGetMinMaxInfo& Message)
{
  MaxPosition = Point(0, (Form1->Height + Form1->Top));

  Message.MinMaxInfo->ptMinTrackSize = MinTrack;        // Minimum Window Size
  Message.MinMaxInfo->ptMaxTrackSize = MaxTrack;        // Maximum Window Size
  Message.MinMaxInfo->ptMaxPosition  = MaxPosition;     // MaxPosition

  Message.Result = 0;
}




//---------------------------------------------------------------------------



void __fastcall TForm2::SplitPanelMouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  SplitPanelDragging = true;

}
//---------------------------------------------------------------------------
void __fastcall TForm2::SplitPanelMouseMove(TObject *Sender, TShiftState Shift,
	int X, int Y)
{
  if(SplitPanelDragging)
  {
    EditorPageControl->Align = alNone;
    SplitPanel->Align = alNone;
    MessageEdit->Align = alNone;
    StatusBar->Align = alNone;
    SplitPanel->Top = SplitPanel->Top + Y  ;
  }

}
//---------------------------------------------------------------------------
void __fastcall TForm2::SplitPanelMouseUp(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  if (SplitPanelDragging)
  {
    SplitPanelDragging = false;
    UpdatePanels();
  }

}
//---------------------------------------------------------------------------
void __fastcall TForm2::UpdatePanels()
{
  MessageEdit->Top = SplitPanel->Top + SplitPanel->Height;
  MessageEdit->Height = StatusBar->Top - SplitPanel->Top - (SplitPanel->Height);

  StatusBar->Align = alBottom;
  MessageEdit->Align = alBottom;
  SplitPanel->Align = alBottom;
  EditorPageControl->Align = alClient;
}




////////////////////////////////////////////////////////////
////////////********************************////////////////
///////////////////// FORM EVENTS //////////////////////////
////////////********************************////////////////
////////////////////////////////////////////////////////////
/////////// Auto- Created By The BCB++ IDE /////////////////

void __fastcall TForm2::FormCreate(TObject *Sender)
{
  Untitleds = 0;
    try {
      TComponent* ThisComponent = dynamic_cast <TComponent*> (Form2) ;
      PrntDlg = new TPrintDialog( ThisComponent );
      PrintSetupDlg = new TPrinterSetupDialog( ThisComponent );
      }
  catch ( ... )
  {
      Application->MessageBox("Printer not initialized!","Printer Problem", MB_OK|MB_ICONWARNING);
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormHide(TObject *Sender)
{
  Form1->View_EditorWindow->Checked = false;
  UpdateControls();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormShow(TObject *Sender)
{
  Form1->View_EditorWindow->Checked = true;

  NewTab();
  NewRichEdit->SetFocus();

}
//---------------------------------------------------------------------------


void __fastcall TForm2::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
  UpdateStatus();
}

//---------------------------------------------------------------------------
void __fastcall TForm2::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  // Checks if RichEdit has been Modified before closing}
  for (int i=0; i<EditorPageControl->PageCount; i++)
  {
    if (CurrentRichEdit()->Modified)
    {
    AnsiString str = "File:  " + EditorPageControl->Pages[i]->Caption + ", has changed. Save now?";

      switch( MessageBox(Handle, str.c_str(), "Confirmation", MB_YESNOCANCEL|MB_ICONQUESTION))
      {
        case ID_YES:
          FileSave();
          CanClose = true;
          break;

        case ID_NO:
          // no saves just close
          CanClose = true;
          break;

        case ID_CANCEL:
          // no saves, no close
          CanClose = false;
          break;
      }
    }
  }
}



/// ****************************************************************///
/// ************          Custom  Functions      *******************///
/// ****************************************************************///
//---------------------------------------------------------------------------
// PutEditorWindow(int top)
// InsertFile( AnsiString FileName)
// CheckCapslock()
// UpdateControls()
// GetCursorPosition(TObject* Sender)
// HandleEditMenu()
// HandleSaveMenu()


//---------------------------------------------------------------------------

// this function gets the mainforms bottom and puts the editor window in the
// right place according to the screen settings. So if you're running
// Visual Assembler in a different mode than 800*600 (640*480 is OK) it will work
// I tried it for fun in 1600*1200 not that I could see anything, but it works !

void __fastcall TForm2::PutEditorWindow(int top)
{

/*
CxScreen,               	// Width of screen in pixels }
CyScreen,               	// Height of screen in pixels }
CxFullScreen,           	// Width of client area in pixels }
CyFullScreen,           	// Heigth of client area in pixels }
CyCaption;  				// Height of a window's title bar in pixels }
*/

int CxScreen      = GetSystemMetrics(SM_CXSCREEN); 		//  Get various screen dimensions
int CyScreen      = GetSystemMetrics(SM_CYSCREEN);      	//and set form's width/height
int CxFullScreen  = GetSystemMetrics(SM_CXFULLSCREEN);
int CyFullScreen  = GetSystemMetrics(SM_CYFULLSCREEN);
int CyCaption     = GetSystemMetrics(SM_CYCAPTION);

// possible max width
int PossibleMaxWidth  = CxScreen - (CxScreen - CxFullScreen) + 1;

// possible max height
int PossibleMaxHeight = CyScreen - (CyScreen - CyFullScreen) + CyCaption + 1;

div_t res = div(PossibleMaxWidth, 4); 	// divide desktop width space into 4 equal parts
// int RealMaxWidth = 3 * res.quot;		// give 3 parts to the code window
int InsertablesMaxWidth = res.quot; 	// give 1 to the insertables window


// set the max, min track positions for the onminmaxinfo message

// position the window takes when it is maximized : the bottom of the mainwindow
MaxPosition = Point(0, top ) ;
// the minimum possible dimensions of the code window
MinTrack    = Point(100,100);
// the maximum possible dimensions of the code window
MaxTrack    = Point(PossibleMaxWidth, PossibleMaxHeight - top);

// SetBounds(int ALeft, int ATop, int AWidth, int AHeight);

int CurrLeft = InsertablesMaxWidth + 30; // +30 is to keep some distance from the ins form
int CurrTop  = top +10; // distance from the mainform
int CurrWidth =  PossibleMaxWidth-InsertablesMaxWidth -80 ;
int CurrHeight = PossibleMaxHeight - top - 80;
// the + / - things have best effect when in 800*600 mode.

// OK all vars set now just set the form :-)

SetBounds(CurrLeft, CurrTop, CurrWidth, CurrHeight);




// Currently only adjustments working if the win95 taskbar is on the bottom (default)
// maybe later i'll work on the code below .

/*
HWND  TaskBarHandle;       	//Handle to the Win95 Taskbar
RECT TaskBarCoord;   		// Coordinates of the Win95 Taskbar
TaskBarHandle 	= FindWindow("Shell_TrayWnd",NULL);    	// Get Win95 Taskbar handle
WindowState 	= wsNormal;
GetWindowRect(TaskBarHandle,&TaskBarCoord);          	// Get coordinates of Win95 Taskbar

if ((TaskBarCoord.top = -2) & (TaskBarCoord.left = -2))
{
  // Taskbar on either top or left
  if (TaskBarCoord.right > TaskBarCoord.bottom)
  {
    //  Taskbar on top
    Top  = TaskBarCoord.bottom;
  }
  else // Taskbar on left
  {
    Form1->Left = TaskBarCoord.right;
  }
}

*/

}




void __fastcall TForm2::InsertFile( AnsiString FileName)
{
  TStringList* Buf = new(TStringList);
  Buf->LoadFromFile(FileName);
  String ExtrnStatement = Buf->Strings[0];
  int p = ExtrnStatement.Pos("extrn");
  if (p != 0) 	// p non zero so there is an extrn statement on the first line.
  { 			// that means this file is an API file
    Buf->Delete(0);     //Strip EXTRN Statement
    Buf->Delete(0);     //Strip NumberOfLines
  }


  CurrentRichEdit()->SelText = Buf->Text;

  delete Buf;

  CurrentRichEdit()->SetFocus();
}




/// ****************************************************************///
/// ************          Custom  Functions      *******************///
/// ****************************************************************///
//---------------------------------------------------------------------------
///   Standard functions that go along with a Rich Text Editor      ///
///  *Cut*, *Copy*, *Paste*, *Selectall*, *Undo*, Redo, *find*, *findagain*, *replace* ///
/// I actually don't like the way theyre handled. Not centralised. We're not
/// programming visual basic, are we ? I will centralize them when I have time

/// Also included here : *Print*, *PrinterSetup*


void __fastcall TForm2::Undo()
{
  CurrentRichEdit()->Perform(EM_UNDO, 0, 0);
  CurrentRichEdit()->SetFocus();
}
void __fastcall TForm2::Redo()
{
// open yet
}

void __fastcall TForm2::Cut()
{

  PostMessage(CurrentRichEdit()->Handle, WM_CUT, 0, 0 );
  CurrentRichEdit()->SetFocus();
}

void __fastcall TForm2::Copy()
{
  PostMessage(CurrentRichEdit()->Handle, WM_COPY, 0, 0 );
  CurrentRichEdit()->SetFocus();

}

void __fastcall TForm2::Paste()
{
  PostMessage(CurrentRichEdit()->Handle, WM_PASTE, 0, 0 );
  CurrentRichEdit()->SetFocus();
}

void __fastcall TForm2::SelectAll()
{
  CurrentRichEdit()->SelectAll();
  CurrentRichEdit()->SetFocus();
}


void __fastcall TForm2::Find()
{
  FindDlg->Execute();
}

void __fastcall TForm2::Replace()
{
  ReplaceDlg->Execute();
}

void __fastcall TForm2::Delete()
{
  // not implemented yet
}

void __fastcall TForm2::SearchAgain()
{
// What should go here ?
}


void __fastcall TForm2::FilePrint()
{
  //PrntDlg->Execute();
//Performs the basic RichEdit printing
  if (PrntDlg->Execute())
  {
    CurrentRichEdit()->Print("Print");
  }
}


void __fastcall TForm2::PrinterSetup()
{
  PrintSetupDlg->Execute();
}


/// ******************************************************************///
/// ************          Functions that control      **********************///
/// ************ the enabling/disabling of the visual things****************///
/// ****************************************************************///
/// ************ like the toolbarbuttons, the statusbar, the caret position,
/// ************ the hint display and so on...
//---------------------------------------------------------------------------


void __fastcall TForm2::AppIdle(TObject* Sender, bool& Done )
{
  Done = true; 			// we don't want to overload the precious CPU time

  // check the enablers for menuitems
  // synchronize with toolbarbuttons

  UpdateMenuItems();
  UpdateToolbarButtons();
  UpdateStatus();

}


void __fastcall TForm2::UpdateMenuItems()
{
  if ((EditorPageControl->ActivePage !=NULL))
  {
//    CurrentRichEdit()->SetFocus();
    Form1->Edit_Paste->Enabled   = Clipboard()->HasFormat(CF_TEXT);
    Form1->Edit_Undo->Enabled    = CurrentRichEdit()->Perform(EM_CANUNDO, 0, 0) != 0;
    Form1->Edit_Cut->Enabled = Form1->Edit_Delete->Enabled = Form1->Edit_Copy->Enabled = CurrentRichEdit()->SelLength > 0;
    Form1->Search_SearchAgain->Enabled = FindDlg->FindText != "";
    Form1->File_Save->Enabled = Form1->File_SaveAll->Enabled   = CurrentRichEdit()->Modified;
  }
}

void __fastcall TForm2::UpdateToolbarButtons()
{
  Form1->TBE->SynchronizeWithMenu();
}


void __fastcall TForm2::UpdateStatus()
{
  if ((EditorPageControl->ActivePage !=NULL))
  {
 // update cursorposition
  int iY = SendMessage(CurrentRichEdit()->Handle, EM_LINEFROMCHAR, CurrentRichEdit()->SelStart, 0);
  int iX = CurrentRichEdit()->SelStart - SendMessage(CurrentRichEdit()->Handle, EM_LINEINDEX, iY, 0);
  StatusBar->Panels->Items[0]->Text = IntToStr(iY + 1) + ':' + IntToStr(iX + 1) ;

  // update Modified/" "  status
  if ( CurrentRichEdit()->Modified) StatusBar->Panels->Items[1]->Text = "Modified";
  else StatusBar->Panels->Items[1]->Text = "";

  // update Insert/ overwrite status
  if (GetKeyState(VK_INSERT))StatusBar->Panels->Items[2]->Text = "Overwrite";
  else StatusBar->Panels->Items[2]->Text = "Insert";
  }
}


void __fastcall TForm2::UpdateControls()
{
  // Enables menu controls, based on the existence of an ActivePage,
  bool yeahsure = EditorPageControl->PageCount != 0;
  Form1->Search_->Enabled =  yeahsure;
  Form1->Edit_->Enabled  = yeahsure;
  Form1->File_Print->Enabled  = yeahsure;
  Form1->File_Close->Enabled  = yeahsure;
  Form1->File_CloseAll->Enabled  = yeahsure;
  Form1->File_Save->Enabled  = yeahsure;
  Form1->File_SaveAll->Enabled  = yeahsure;
  Form1->File_SaveAs->Enabled  = yeahsure;

}


/// ******************************************************************///
/// ************          Functions that handle Files   **********************///
/// ************ File Open, Close, Save, SaveAll, SaveAs, CloseAll ****************///
/// ****************************************************************///



///************NewRichEditSetup*****************///
/// This function takes a TRichEdit as a variable
/// and modifies the properties from the component
/// defaults to the values we want.
///*********************************************///

void __fastcall TForm2::NewRichEditSetup(TRichEdit* NewRE)
{
  NewRE->Align 					= alClient;
  NewRE->Parent 				= NewTabSheet;
  NewRE->ScrollBars 			= ssBoth;
  NewRE->HideScrollBars			= false;
  NewRE->HideSelection 			= false;
  NewRE->WordWrap				= false;
  NewRE->WantTabs 				= true;
  NewRE->ShowHint 				= false;
  NewRE->Modified 				= false;
  NewRE->MaxLength = 0;         // no maxlength

  // set the Events to this new Page
  NewRE->OnChange 				= &RichEditChange;
  NewRE->OnSelectionChange 		= &RichEditSelectionChange;
  NewRE->OnDragDrop 			= &RichEditDragDrop;
  NewRE->OnDragOver 			= &RichEditDragOver;
  NewRE->OnKeyUp 				= &RichEditKeyUp;
  NewRE->OnMouseDown 			= &RichEditMouseDown;

  SetRichEditFont(NewRE);
}



/// ***************    NewTab() ***************************** ///
/// This procedure is called from the File_New menu           ///
/// It sets up a new tab, a richedit and initializes data for ///
/// them													  ///
///   ******************************************************* ///

void __fastcall TForm2::NewTab()
{
  if (!Visible) Show(); 
  Untitleds++ ;// increase this global integer var. It stands for # of untitled windows.

  //Create the NewTabSheet
  NewTabSheet = new TTabSheet(EditorPageControl);
  NewTabSheet->Visible = false;
  NewTabSheet->PageControl = EditorPageControl;

  //creates a NewRichEdit and sets the NewTabSheet as the parent
  NewRichEdit = new TRichEdit(NewTabSheet);
  NewRichEdit->Visible = false;
  NewRichEdit->Parent = NewTabSheet;
  NewRichEdit->Align  = alClient;
  NewRichEdit->ScrollBars = ssBoth;
  NewRichEdit->WordWrap = false;
  NewRichEdit->WantTabs = true;
  NewRichEdit->HideSelection = false;
  NewRichEdit->ShowHint = false;

  NewRichEditSetup(NewRichEdit);

  //Set the NewTabSheet Properties
  NewTabSheet->Caption = "Untitled" + IntToStr(Untitleds);
  NewTabSheet->Hint = NewTabSheet->Caption;

  EditorPageControl->ActivePage = NewTabSheet;
  EditorPageControl->ActivePage->PopupMenu = PopupMenu;
  EditorPageControl->ShowHint = false;


  NewRichEdit->Visible = true;
  NewTabSheet->Visible = true;
  
  NewRichEdit->Modified = false;

  SetRichEditFont(NewRichEdit);

  UpdateControls();
}


/// ***************    FileOpen()   *************************** 	///
/// This procedure is called from the File_Open menu        		///
/// It shows the openfile dialogbox and afterwards opens the file   ///
/// using the LoadFile Procedure                                    ///
///   *******************************************************   	///

void __fastcall TForm2::FileOpen()
{
  //File Open procedure
  //***why does the set font function not work when opening files???***
  try
  {
    if (FileOpenDlg->Execute())
    {
      LoadFile(FileOpenDlg->FileName);
    }
    UpdateControls();
  }
  catch ( ... )
  {
    throw;
  }
}


/// ***************    LoadFile(AnsiString FName)   *********** 	///
/// This procedure is called from the FileOpen Procedure        	///
/// It will also be called from wizard procedures to load a project ///
/// It creates and sets up a new tabsheet, and a new richedit   	///
/// It reads the file and highlights the code. (not yetunfortunately)//
///   *******************************************************   	///

void __fastcall TForm2::LoadFile(AnsiString FileName)
{
  if (FileExists(FileName))
  {
    Screen->Cursor = crHourGlass;
    NewTabSheet = new TTabSheet(EditorPageControl);
    try
    {
      // set up the new tabcontrol
      NewTabSheet->Caption = ExtractFileName(FileName);
      NewTabSheet->Hint = FileName;
      NewTabSheet->ShowHint = false;
      NewTabSheet->Tag = 1;
      NewTabSheet->PageControl = EditorPageControl;
      EditorPageControl->ActivePage = NewTabSheet;
      EditorPageControl->ActivePage->PopupMenu = PopupMenu;
      EditorPageControl->ShowHint = false;
      // create and setup the new richedit
      NewRichEdit = new TRichEdit(NewTabSheet);
      NewRichEditSetup(NewRichEdit);
      // sends file through the ASMToRtf conversion unit
      // Coming Soon :-)
      /*
      PasCon := TPasConversion.Create;
      PasCon.UseDelphiHighlighting(3);
      PasCon.LOADFROMFILE(FName);
      PasCon.ConvertReadStream;
      NewRichEdit.Lines.BeginUpdate;
      NewRichEdit.Lines.LoadFromStream(PasCon);
      NewRichEdit.Lines.EndUpdate;
      */
      // just load the lines normally for now !

      // this beginupdate and endupdate thing speeds up loading till 400%
      NewRichEdit->Lines->BeginUpdate();
      NewRichEdit->Lines->LoadFromFile(FileName);
      NewRichEdit->Lines->EndUpdate();
      ActiveControl = NewRichEdit;
      NewRichEdit->Modified = false;
      UpdateControls();
    }
    catch ( ... )
    {
      Screen->Cursor = crDefault;
      SetForegroundWindow(Handle);
      throw;
    }
    Screen->Cursor = crDefault;
    SetForegroundWindow(Handle);
  }
  // else file does not exist !
}





/// ***************    FileSave() ***************************** ///
/// This procedure is called from the File_Save menu            ///
/// It saves the Active Editor Tab according to the file ext    ///
/// it has. 												    ///
/// the filename is taken from the pagecontrols hint property   ///
///																///
///   *******************************************************   ///

/// Currently all files are saved as plain text files
/// except those with the rtf extension


void __fastcall TForm2::FileSave()
{
  //Saves the file based on which file extension is selected
  bool PlainText;
  String FileName = EditorPageControl->ActivePage->Hint; // let's make this code readable

  // if still not saved, save it first as ...
  if (! (FileExists(FileName) ))
  {
    FileSaveAs();
  }
  else
  {
    //it gets saved as a plain text file}
    PlainText =CurrentRichEdit()->PlainText;

    // is the file a rtf ?
    CurrentRichEdit()->PlainText = (UpperCase(ExtractFileExt(FileName)) != ".RTF");
    CurrentRichEdit()->Lines->SaveToFile(FileName);

    CurrentRichEdit()->PlainText = PlainText;
    CurrentRichEdit()->Modified = false;
    EditorPageControl->ActivePage->Caption = ExtractFileName(FileName);

  }
}


/// ***************    FileSaveAs() ***************************** 	///
/// This procedure is called from the File_SaveAs menu          	///
/// It saves the Active Editor Tab according to the choosen filename///
/// from the savedialog. If savedialog index 2 = "*.RTF" is chosen  ///
/// the file is saved as a rtf else as a plain text file        	///
///   *******************************************************   ///


void __fastcall TForm2::FileSaveAs()
{
  bool PlainText;

  if (FileSaveDlg->Execute())
  {
    PlainText = CurrentRichEdit()->PlainText;
    // savedlg->FilterIndex has to be *.rtf
    CurrentRichEdit()->PlainText = FileSaveDlg->FilterIndex != 2;
    CurrentRichEdit()->Lines->SaveToFile(FileSaveDlg->FileName);
    CurrentRichEdit()->PlainText = PlainText;
    EditorPageControl->ActivePage->Caption = ExtractFileName(FileSaveDlg->FileName);
    EditorPageControl->ActivePage->Hint = FileSaveDlg->FileName;
    CurrentRichEdit()->Modified = false;
  }
}




/// ***************FileCloseAll() ***************************** 	///
/// This procedure is called from the File_CloseAll menu          	///
/// It closes all files that are unmodified and prompts for			///
/// modified files using the CloseFile() method                     ///
///   *******************************************************   	///

void __fastcall TForm2::FileCloseAll()
{
  for(int i= EditorPageControl->PageCount-1 ; i >-1 ; i-- ) // countdown
  {
    EditorPageControl->ActivePage = EditorPageControl->Pages[i];
    FileClose();
  }
}


/// ***************FileSaveAll() ***************************** 		///
/// This procedure is called from the File_SaveAll menu          	///
/// It saves and closes all files that have an existing name		///
/// and prompts for those which don't have a filename yet 			///
/// Later support will be added to save whole projects				///
///   *******************************************************   	///

void __fastcall TForm2::FileSaveAll()
{
  //Save All modified RichEdits
  for (int i = EditorPageControl->PageCount-1; i>0; i--) //countdown
  {
    EditorPageControl->ActivePage = EditorPageControl->Pages[i];
    FileSave();
  }
}

/// *************** FileClose() ***************************** 		///
/// This procedure is called from the File_Close menu 	         	///
/// It closes the active editor if it hasn't been modified,         ///
/// prompts if it has been.											///
///   *******************************************************   	///

void __fastcall TForm2::FileClose()
{
if (Visible)
  { //Close the active page
  if (CurrentRichEdit()->Modified)
  {
    AnsiString str = "File:  " + EditorPageControl->ActivePage->Caption + ", has changed. Save now?";
    switch( MessageBox(Handle, str.c_str(), "Confirmation", MB_YESNOCANCEL|MB_ICONQUESTION))
    {
      case ID_YES:
        FileSave();
        EditorPageControl->ActivePage->Free();
        EditorPageControl->SelectNextPage(false);
        UpdateControls();
        break;
      default :
        EditorPageControl->ActivePage->Free();
        EditorPageControl->SelectNextPage(false);
        UpdateControls();
    }
  }
  else // not modified
  {
    EditorPageControl->ActivePage->Free();
    EditorPageControl->SelectNextPage(false);
    UpdateControls();
  }
  // was it the last one ?
  if (EditorPageControl->ActivePage == 0)
  Close(); // then just close the window
  }
}



///////////////////////////////////////////////////////////
////////////********************************////////////////
///////////////////// RICHEDIT EVENTS ///////////////////////
////////////********************************////////////////
///////////////////////////////////////////////////////////


void __fastcall TForm2::RichEditDragDrop(TObject *Sender, TObject *Source,
	int X, int Y)
{
  TFileListBox* Box = dynamic_cast<TFileListBox*>(Source);
  if (Box)
  {
    if (FileExists(Box->FileName))
    InsertFile(Box->FileName);
  }

  CurrentRichEdit()->SetFocus();

}
//---------------------------------------------------------------------------
void __fastcall TForm2::RichEditDragOver(TObject *Sender, TObject *Source,
	int X, int Y, TDragState State, bool &Accept)
{
    Accept = true;  // no need to check wether it is a filelistbox. we'll do that on drop !
}
//---------------------------------------------------------------------------


void __fastcall TForm2::RichEditChange(TObject* Sender)
{
  //Places an asterisk on TabSheet's tab which contains a Modified RichEdit
  if(  (EditorPageControl->ActivePage!=NULL) & (CurrentRichEdit()->Modified) &
       (EditorPageControl->ActivePage->Caption.AnsiLastChar() == "*" )
  	)
  {
    EditorPageControl->ActivePage->Caption = EditorPageControl->ActivePage->Caption + "*";
  }
}

//---------------------------------------------------------------------------
void __fastcall TForm2::RichEditKeyUp(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
  UpdateStatus();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::RichEditMouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  UpdateStatus();
}
//---------------------------------------------------------------------------


void __fastcall TForm2::RichEditSelectionChange(TObject *Sender)
{
  // you could set the caret position if you wish to here !
}
//---------------------------------------------------------------------------
TRichEdit* __fastcall TForm2::CurrentRichEdit(void)
{
  return (TRichEdit*)EditorPageControl->ActivePage->Controls[0];
}










//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenuPopup(TObject *Sender)
{
  // check all the popupitems if they have to be enabled before displaying the popup.
  PopupMenu_ClosePage->Enabled = Form1->File_Close->Enabled;
  PopupMenu_CloseAllPages->Enabled = Form1->File_CloseAll->Enabled;
  PopupMenu_New->Enabled = Form1->File_New->Enabled;
  PopupMenu_Open->Enabled = Form1->File_Open->Enabled;
  PopupMenu_Save->Enabled = Form1->File_Save->Enabled;
  PopupMenu_SaveAs->Enabled = Form1->File_SaveAs->Enabled;
  PopupMenu_SaveAll->Enabled = Form1->File_SaveAll->Enabled;
  PopupMenu_Find->Enabled = Form1->Search_Find->Enabled;
  PopupMenu_Replace->Enabled = Form1->Search_Replace->Enabled;
}

void __fastcall TForm2::PopupMenu_ClosePageClick(TObject *Sender)
{
  FileClose();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_CloseAllPagesClick(TObject *Sender)
{
  FileCloseAll();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_NewClick(TObject *Sender)
{
  NewTab();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_OpenClick(TObject *Sender)
{
  FileOpen();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_SaveClick(TObject *Sender)
{
  FileSave();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_SaveAsClick(TObject *Sender)
{
  FileSaveAs();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_SaveAllClick(TObject *Sender)
{
  FileSaveAll();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_FindClick(TObject *Sender)
{
  // Find();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_ReplaceClick(TObject *Sender)
{
  // Replace();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::Popup_Font_IDMClick(TObject *Sender)
{
	TRichEdit* RE = reinterpret_cast <TRichEdit*>(PopupMenu->PopupComponent);
  if (RE)
  {
  if ( FontDialog1->Execute() ) {
   RE->Font->Assign( FontDialog1->Font );
   TIniFile* IniFile = new TIniFile( ChangeFileExt(ParamStr(0),".INI"));
   IniFile->WriteString("Defaults", "EditorFont", FontDialog1->Font->Name);
   IniFile->WriteInteger("Defaults", "EditorFontSize", FontDialog1->Font->Size);
   IniFile->Free();

  }
  }

}
void __fastcall TForm2::SetRichEditFont(TRichEdit* NewRE)
{
  TIniFile* IniFile = new TIniFile( ChangeFileExt(ParamStr(0),".INI"));
  int FontSize = IniFile->ReadInteger("Defaults", "EditorFontSize", 10);
  AnsiString StoredFont = IniFile->ReadString("Defaults", "EditorFont", "Courier New");
  NewRE->SelAttributes->Name= StoredFont;
  NewRE->SelAttributes->Size = FontSize;
  IniFile->Free();
}
//---------------------------------------------------------------------------


